/*******************************************************
Filename		:  	DW_selection_criteria.sql
Release 		:  	STORET c2.0
SIR			:  	1363, 1364, 1365, 1366, 1367, 1369, 1501
Description		:  	Creates a centralized form page that allows the user to select 
				all the most common parameters to query Stations. This information
				is passed to the DW_station_count procedure.
Author            :     Joseph Wilson
Date                    November 5, 2002; November 11, 2002; November 22, 2002; December 5, 2002; December 9, 2002
                        April 30, 2003 --Pass '31' to footer routine to be used as a bookmark for the Help. - W Nash sir 1459  
                        5/1/2003 -- Changed to allow search by characteristic alias. Adjusted tab sequencing. - C Tsang
                        5/10/2003 --Removed hard-coded schema references -J Wilson
                        6/20/2003 --SIR 1504 - Replaced code for geo and char selections with procedure calls. -CT
                        08/15/2003 - Removed 'BETA' from the page title. -CT
			08/22/2003 - Added STATION_FLAG=ON to Characteristics section -JW
			06/18/2004 - Changed name of Org list var to D_ORG_LIST2 -JW
Comments		:  	Calls three pop-up screens that allow the user to enter additional
				information.
**********************************************************/

SET DEF OFF;

CREATE or REPLACE PROCEDURE DW_StationCriteria AS
CURSOR cstype IS 
SELECT primary_type,secondary_type, PK_ISN, sort_order
FROM DI_STATN_TYPES
order by sort_order,primary_type,secondary_type;

CURSOR corg IS
SELECT pk_isn, organization_id, organization_name
FROM DI_ORG
order by organization_id;

--stype_value	varchar2(100);
program_path  	varchar2(1000) := null;
script_path   	varchar2(1000) := null;
image_path    	varchar2(1000) := null;
page_title    	varchar2(100)  :='Stations by Geographic Location';

BEGIN
DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path,'adjust_width_n(document.forms[1].D_STYPE_LIST,"~","35~30","None","Y");adjust_width_n(document.forms[1].D_ORG_LIST2,"~","15~60","None","Y");document.forms[1].reset();');
htp.print('<form action="DW_STATION_COUNT" method=POST>');

-- Geographic selection
DW_geo_select;

-- Station Type selection
htp.print ('
<h4>Station Type</h4>
<table BORDER COLS=1 WIDTH="100%">
<tr><td align="center">
Select one or more Station Type(s)
<BR>
<INPUT TYPE="TEXT" READONLY style="font: 10pt/12pt COURIER"  VALUE="PRIMARY_TYPE                         SECONDARY_TYPE" size="69"  onFocus="javascript:this.blur()">
<FONT face="Courier">
<SELECT NAME="D_STYPE_LIST" SIZE="10"  MULTIPLE style="font: 10pt/12pt COURIER" tabindex=15>
<OPTION SELECTED  value="ALL">Select All_________________________________________________________');

    for cstype_var in cstype  LOOP
--      stype_value:=TRANSLATE(cstype_var.primary_type,' ','$')||'~'||TRANSLATE(cstype_var.secondary_type,' ','$');
      htp.formSelectOption(cstype_var.PRIMARY_TYPE||'~'||cstype_var.SECONDARY_TYPE, cattributes => 'value= '||cstype_var.PK_ISN);
    END LOOP;

htp.print('</SELECT>
<BR>
</TD>
</TR>
</TABLE>');

-- Characteristics selection
DW_char_select(18,'REGULAR','ON');

-- Organization selection
htp.print('
<BR>
<H4>Organization</H4>
<table width="100%" cols=1 border=1>
<TR>
<TD align="center">
Select one or more Organization(s)
<br>
<!-- INPUT TYPE="TEXT" READONLY style="font: 10pt/12pt COURIER"  VALUE="ORGANIZATION_NAME                                                  ORG_ID" size="78"  onFocus="javascript:this.blur()" -->
<INPUT TYPE="TEXT" READONLY style="font: 10pt/12pt COURIER"  VALUE="ORG_ID                              ORGANIZATION_NAME" size="78"  onFocus="javascript:this.blur()">
<br>
<font face="Courier">');

	htp.formSelectOpen('D_ORG_LIST2', nsize => '10', cattributes => 'tabindex=24 multiple style="font:  10pt/12pt COURIER"'); 
      htp.formSelectOption('Select All_________________________________________________________________',cselected => 'TRUE', cattributes => 'VALUE="ALL"');		
	FOR org IN corg LOOP
        	--htp.formSelectOption(org.organization_name||'~'||org.organization_id, cattributes => 'VALUE='||org.pk_isn);
		htp.formSelectOption(org.organization_id||'~'||org.organization_name, cattributes => 'VALUE='||org.pk_isn);
	END LOOP;

HTP.PRINT('</SELECT>
</font><br><br>
</td>
</TR>
</TABLE>

<br>
<center>
<input type="button" value="Continue" tabindex=25 onclick="javascript: submitCriteria();" title="Submit Selection Criteria for processing">&nbsp&nbsp&nbsp
<input type="button" value="Clear Form" tabindex=26 onclick="javascript: deleteAllFromCharList(); document.forms[1].reset();" title="Clear the form">
</center></form>
');
DW_bottom_of_page(31);

END;
/
SHOW ERRORS;